<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\AlphabetContent;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\AlphabetBooks;

class LinkAlphabetsToCategories extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::hasModel('alphabet_books')) {
            return;
        }

        AlphabetBooks::doesntHave('alphabetBooksCategories')->each(fn ($content) => AlphabetContent::assignToCategory($content));
    }
}
