<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddEnhancedViewToFollow extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        /**
         * @var Illuminate\Support\Collection $followNotificationTypes
         */
        $followNotificationTypes = NotificationType::where([
            'action' => 'follow',
            'via' => 'email',
        ])->get();

        $followNotificationTypes->each(
            fn (NotificationType $notificationType) => $this->addViewAttribute($notificationType)
        );
    }

    private function addViewAttribute(NotificationType $notificationType): void
    {
        $data = $notificationType->data;
        $data['view'] = 'enhancedEmail';
        $notificationType->data = $data;
        $notificationType->save();
    }
}
