<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class SetTextTwoColumnAsSearchable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(['text_left', 'text_right'])->each(
            fn ($field) => $bridge->updateFieldOptions(
                type: 'text_two_columns',
                fieldName: $field,
                options: [
                    'searchable' => true,
                ],
            )
        );
    }
}
