<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class DeleteFieldRegistrationEnabledOnSomeInstances extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    private const INSTANCES_TO_LEAVE_OUT = [
        '14py', 'ageo', 'agfr', 'agre', 'alfa', 'bobi', 'bpam',
        'cpas', 'cuis', 'demo', 'duva', 'efsa', 'fare', 'ibca',
        'ifvd', 'ipri', 'isdr', 'ixif', 'kera', 'obph', 'qual',
        'scje', 'sgg', 'sofi', 'soge', 'syan', 'work', 'sewa',
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (in_array(env('APP_CODE'), self::INSTANCES_TO_LEAVE_OUT)) {
            return;
        }

        if (! Schema::hasContentType('events') || ! Schema::hasField('events', 'registration_enabled')) {
            return;
        }

        $bridge->contentTypeDeleteField('node', 'events', 'registration_enabled');
    }
}
