<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class RemoveAlphabetContentTypes extends Migration
{
    public function up(): void
    {
        $contentTypes = [
            'alphabet_books',
            'alphabet_books_categories',
        ];

        $bridgeContentType = new BridgeContentType();
        foreach ($contentTypes as $contentType) {
            if (Schema::hasContentType($contentType)) {
                $bridgeContentType->contentTypeDelete($contentType);
            }
        }
    }
}
