<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddIntroductionFieldToCustomType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        try {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'custom',
                fieldName: 'introduction',
                options: [
                    'name' => 'introduction',
                    'searchable' => false,
                    'translatable' => false,
                    'default' => false,
                    'search_result_field' => false,
                    'required' => false,
                    'weight' => -3,
                    'title' => [
                        'fr' => 'Introduction',
                        'en' => 'Custom page',
                        'es' => 'Página personalizada',
                        'pt' => 'Página personalizada',
                        'de' => 'Benutzerdefinierte Seite',
                        'nl' => 'Pagina op maat',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::LONGTEXT_WIDGET,
                        'settings' => [
                            'rows' => 5,
                            'placeholder' => '',
                        ],
                        'weight' => -3,
                    ],
                    'type' => BridgeContentType::TEXTAREA_FIELD,
                    'settings' => [
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ],
                weight: -3
            );
        } catch (Exception $e) {
            return;
        }
    }
}
