<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class RollbackAltFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $fieldsWidgetTypes = ['inside_link_field_widget'];

        foreach ($fieldsWidgetTypes as $widgetType) {
            $returnedFields = Schema::getAllFieldsListingOfWidget($widgetType);

            foreach ($returnedFields as $item) {
                if (! Schema::hasField($item[0], $item[1].'_alt')) {
                    continue;
                }

                if ($item[0] == 'users') {
                    $bridge->contentTypeDeleteField('user', 'user', $item[1].'_alt');
                } else {
                    $bridge->contentTypeDeleteField('node', $item[0], $item[1].'_alt');
                }
            }
        }

        $existingTypes = ['button', 'call_to_action', 'file', 'files', 'custom'];
        $allContentTypes = Schema::getContentTypes();
        foreach ($existingTypes as $type) {
            foreach ($allContentTypes as $contentType) {
                if (in_array($contentType, ['comments', 'users'])) {
                    continue;
                }
                $contentTypeFieldsOfType = Schema::getFieldListingOfType($contentType, $type);
                foreach ($contentTypeFieldsOfType as $field) {
                    $bridge->contentTypeDeleteField('node', $contentType, $field.'_alt');
                }
            }
        }
    }
}
