<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

final class DeactivateFormerMaeciaMembers extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $formerMembers = [
            'alice.maixent@maecia.com',
            'augustin.goldblum@maecia.com',
            'camille.weintz@maecia.com',
            'charles.bourgeaux@maecia.com',
            'dana.ducros@maecia.com',
            'florian.zobele@maecia.com',
            'leo.brossault@maecia.com',
            'loris.birkemeyer@maecia.com',
            'lorry.guedj@maecia.com',
            'lucie.foulhac@maecia.com',
            'maxime.jacquot@maecia.com',
            'nicolas@maecia.com',
            'pauline.leborgne@maecia.com',
            'stephane.soler@maecia.com',
            'tedj.ferhati@maecia.com',
            'thibault.dantigny@maecia.com',
            'louise.gibier@maecia.com',
        ];

        $bridge = new BridgeContent();

        Users::whereIn('email', $formerMembers)
            ->where('status', true)
            ->pluck('uuid')
            ->each(fn (string $uuid) => $bridge->contentUpdate('users', ['uuid' => $uuid, 'status' => false]));
    }
}
