<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;

final class RunParagraphsConfiguration extends Migration
{
    public function up(): void
    {
        $command = collect(['php', '-d memory_limit=-1', cms_base_path('vendor/bin/drush'), 'config:export'])->join(' ');
        exec(windows_os() ? str_replace('/', '\\', $command) : $command);

        Artisan::call('inside:paragraph:bundles:translatable');
        Artisan::call('inside:paragraph:config:generate');
        Artisan::call('inside:paragraph:config:import');
    }
}
