<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class CreateInviteSectionType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (Schema::hasSectionType('invite')) {
            return;
        }

        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Invite section type');

        $this->migrateContent('invite', false, 'sections');
        $this->getConsole()->writeln('<info>Ajout du nouveau type de paragraph</info>');

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }
}
