<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\App;
use Inside\Content\Contracts\SchemaService;
use Inside\Host\Migrations\CreateContentTypes;

final class FixWysiwygFields extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (count(list_languages()) < 2) {
            return;
        }
        $this->bootUp(__FILE__, 'fix_wysiwyg_fields');

        /** @var SchemaService $service */
        $service = App::make(SchemaService::class);

        $bridge = $this->getBridge();
        $console = $this->getConsole();
        $console->writeln('Vérification des champs wysiwyg mal configuré');
        foreach ($service->getAllFieldsListingOfType('wysiwyg') as $type => $fieldNames) {
            $console->writeln(__(
                '<module>Pour le type :type</module>',
                [
                    'type' => $type,
                ]
            ));
            foreach ($fieldNames as $fieldName) {
                $console->write(__(
                    '=> <info>:fieldName</info>',
                    [
                        'fieldName' => $fieldName,
                    ]
                ));
                try {
                    $options = $service->getFieldOptions($type, $fieldName);
                    if (isset($options['translatable']) && $options['translatable'] === true) {
                        $console->write(' <note>[Déjà bon]</note>');
                        $this->writeResult(true);
                        continue;
                    }
                    $options['translatable'] = true;
                    $console->write(' <note>[à corriger]</note>');
                    $bridge?->updateFieldOptions($type, $fieldName, $options);
                    $this->writeResult(true);
                } catch (Exception $exception) {
                    $console->write(__(
                        ' <error> Échec :message</>',
                        [
                            'message' => $exception->getMessage(),
                        ]
                    ));
                    $this->writeResult(false);
                }
            }
        }

        $this->finishUp();
    }
}
