<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

final class CreateInsideRevisionsTable extends Migration
{
    public function up(): void
    {
        Schema::create(
            'inside_revisions',
            function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->uuidMorphs('contentable');
                $table->string('locale', 2);
                $table->binary('data');
                $table->integer('version')->default(1);
                $table->timestamps();
                $table->index(['contentable_type', 'contentable_id', 'locale']);
            }
        );
        DB::statement('ALTER TABLE `inside_revisions` CHANGE `data` `data` MEDIUMBLOB');
    }
}
