<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class FixContentFieldConfig extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Correction des sections');

        foreach (Schema::getAllFieldsListingOfType('section') as $type => $fieldNames) {
            foreach ($fieldNames as $fieldName) {
                $this->getConsole()->write(
                    'Correction de la cardinalité du champ "section" <fg=cyan>'.
                    $fieldName.'</> sur le type de contenu <fg=magenta>'.$type.'</>'
                );
                $this->writeResult(
                    $this->getBridge()?->switchCardinalityFromUnaryToMultiple($type, $fieldName, true)
                );
            }
        }

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }
}
