<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\DynamicClass;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class CreateCallToActionSectionType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (Schema::hasSectionType('call_to_action')) {
            return;
        }

        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Call to action section type');

        $this->migrateContent('call_to_action', false, 'sections');
        $this->getConsole()->writeln('<info>Ajout du nouveau type de paragraph</info>');

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
