<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\ImageStyles;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddSliderImageStyle extends Migration
{
    public function up(): void
    {
        if (! Schema::hasContentType('image_styles')) {
            return;
        }

        if (Schema::hasField('image_styles', 'resizable')) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'image_styles',
            'resizable',
            [
                'name' => 'resizable',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Redimensionner l\'image',
                    'en' => 'Resize image',
                ],
                'description' => [
                    'fr' => 'Avec cette option, l\'image générée gardera son ratio et aura des bandes blanches sur les côtés',
                    'en' => 'With this option, the generated image will keep its ratio and will have blank borders',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ]
        );

        $imageStyles = ImageStyles::query()->get();

        $bridgeContent = new BridgeContent();

        foreach ($imageStyles as $imageStyle) {
            $bridgeContent->contentUpdate('image_styles', [
                'uuid' => $imageStyle->uuid,
                'resizable' => false,
            ]);
        }

        $bridgeContent->contentInsert('image_styles', [
            'type' => 'node',
            'bundle' => 'image_styles',
            'title'                    => 'slider',
            'width'              => 752,
            'height'             => 440,
            'optimisation'       => true,
            'optimisation_ratio' => 80,
            'resizable'          => true,
        ]);

        if (! Schema::hasSectionType('slide')) {
            return;
        }

        $bridge->updateFieldOptions(
            'slide',
            'image',
            [
                'type'    => BridgeContentType::IMAGE_FIELD,
                'special' => [
                    'image_styles' => ['slider'],
                ],
            ]
        );
    }
}
