<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\ImageStyles;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Support\Str;

class ChangeImageFieldSettings extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        foreach (InsideSchema::getAllFieldsListingOfType('image') as $type => $fields) {
            if (Str::endsWith($type, '_menus')) {
                continue;
            }
            foreach ($fields as $fieldName) {
                try {
                    $options = InsideSchema::getFieldOptions($type, $fieldName);
                    $styles = ImageStyles::query()->whereIn('uuid', $options['image_styles'])->pluck('title')->toArray();
                    $bridge->updateFieldOptions(
                        $type,
                        $fieldName,
                        [
                            'type'    => BridgeContentType::IMAGE_FIELD,
                            'special' => [
                                'image_styles' => $styles,
                            ],
                        ]
                    );
                } catch (Throwable $e) {
                    continue;
                }
            }
        }
    }

    public function down(): void
    {
    }
}
