<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;
use Inside\Content\Facades\Schema as InsideSchema;

class FixPublishedAtOnContents extends Migration
{
    public function up(): void
    {
        foreach (InsideSchema::getContentTypes() as $type) {
            if (Str::endsWith($type, '_menus') || in_array($type, ['comments', 'users'])) {
                continue;
            }
            /** @var string $table */
            $table = type_to_table($type);
            if (! Schema::hasColumn($table, 'published_at')) {
                continue;
            }

            $contents = DB::table($table)->where('published_at', '0000-00-00 00:00:00')->get();

            if ($contents->count() === 0) {
                continue;
            }

            foreach ($contents as $content) {
                DB::table($table)->where('uuid', $content->uuid)->update(['published_at' => $content->created_at]);
            }
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('wysiwyg_images');
    }
}
