<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWysiwygImagesTable extends Migration
{
    public function up(): void
    {
        Schema::create('wysiwyg_images', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('imageable_id')->nullable();
            $table->string('imageable_type')->nullable();

            $table->string('filename');
            $table->string('internal');
            $table->string('internal_path')->default('/');
            $table->string('disk', 50);
            $table->string('hash');
            $table->string('mimetype', 100);
            $table->integer('size');
            $table->timestamps();
            $table->unique(['disk', 'internal_path', 'internal']);
            $table->index(['imageable_id', 'imageable_type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wysiwyg_images');
    }
}
