<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\ImageStyles;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Support\Str;

class CreateNewImagesStylesAndApplyThem extends Migration
{
    use CreateContentTypes;

    protected array $styles = [
        [
            'title'                    => 'thumbnail',
            'field_width'              => 330,
            'field_height'             => 200,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'image_card',
            'field_width'              => 360,
            'field_height'             => 241,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'image_grouping',
            'field_width'              => 418,
            'field_height'             => 128,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'banner_page',
            'field_width'              => 1920,
            'field_height'             => 240,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'banner_page_small',
            'field_width'              => 640,
            'field_height'             => 240,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'banner_home',
            'field_width'              => 1920,
            'field_height'             => 340,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'banner_home_small',
            'field_width'              => 640,
            'field_height'             => 340,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'avatar',
            'field_width'              => 160,
            'field_height'             => 160,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'image_section',
            'field_width'              => 752,
            'field_height'             => 0,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => false,
        ],
        [
            'title'                    => 'slider',
            'field_width'              => 752,
            'field_height'             => 440,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
            'field_resizable'          => true,
        ],
    ];

    protected function createImageStyles(): void
    {
        $bridge = new BridgeContent();
        $old_styles = ImageStyles::get();

        foreach ($old_styles as $old_style) {
            $bridge->contentDelete('image_styles', $old_style->uuid);
        }

        $langcode = config('app.locale', 'fr');

        $this->getConsole()->writeln('Langue du site détecté : ['.$langcode.']');

        $author = Users::where('email', config('app.technical_mail'))->first();

        $this->getConsole()->writeln('<info>Régénération des styles par défaut Inside 2</info>');

        foreach ($this->styles as $style) {
            $style['type'] = 'node';
            $style['bundle'] = 'image_styles';
            $style['langcode'] = $langcode;
            $style['author'] = $author->uuid;
            $this->getConsole()->writeln('<note>Ajout du style <class>'.$style['title'].'</class></note>');
            $bridge->contentInsert('image_styles', $style);
        }
    }

    protected function applyAllStyles(): void
    {
        $this->bootUp(__FILE__, 'create-new-images-styles-and-apply-them');
        foreach (InsideSchema::getAllFieldsListingOfType('image') as $type => $fields) {
            if (Str::endsWith($type, '_menus')) {
                continue;
            }
            $this->getConsole()->writeln(
                'Mise-à-jour du <fg=blue>'.(InsideSchema::isSectionType($type) ? 'paragraphe' : 'contenu')
                .'</> <fg=cyan>'.$type.'</>'
            );
            foreach ($fields as $fieldName) {
                try {
                    $this->getConsole()->write('Ajout de tous les styles au champ <fg=magenta>'.$fieldName.'</>');
                    $this->getBridge()?->updateFieldOptions(
                        $type,
                        $fieldName,
                        [
                            'type'    => BridgeContentType::IMAGE_FIELD,
                            'search'  => [
                                'searchable'          => 0,
                                'global_searchable'   => 0,
                                'search_result_field' => 0,
                                'searchable_filter'   => 0,
                            ],
                            'special' => [
                                'image_styles' => [
                                    'thumbnail',
                                    'image_card',
                                    'image_grouping',
                                    'banner_page',
                                    'banner_page_small',
                                    'banner_home',
                                    'banner_home_small',
                                    'avatar',
                                    'image_section',
                                ],
                            ],
                        ]
                    );
                    $this->getConsole()->writeln(' <fg=green>✔</fg=green>');
                } catch (Throwable $e) {
                    $this->getConsole()->writeln(' <fg=red>✘</fg=red>');
                    $this->getConsole()->writeln('<fg=red;bg=white>'.$e->getMessage().'</>');
                    continue;
                }
            }
            $this->getConsole()->writeln('<fg=yellow>'.str_repeat('-', 80).'</>');
        }
        $this->getConsole()->writeln('<fg=green>Démarrage de la génération des images en tâche de fond </>');
        $this->call('inside:images:generate');
        $this->finishUp();
    }

    public function up(): void
    {
        $this->createImageStyles();
        $this->applyAllStyles();
    }

    public function down(): void
    {
    }
}
