<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldRedirectionPageForCustomContentType extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::hasContentType('custom')) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'custom',
            'redirection_page',
            [
                'type' => BridgeContentType::TEXT_FIELD,
                'name' => 'redirection_page',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Page de redirection',
                ],
                'settings'            => [
                    'cardinality' => 1,
                ],
                'widget'              => [
                    'type'     => BridgeContentType::TEXT_WIDGET,
                    'settings' => [],
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
