<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Users;

class AddNewFieldsOnContentTypes extends Migration
{
    public function up(): void
    {
        $contentTypes = Inside\Content\Facades\Schema::getContentTypes();

        foreach ($contentTypes as $contentType) {
            /** @var string $tableName */
            $tableName = type_to_table($contentType);

            if (Schema::hasColumn($tableName, 'update_author')) {
                continue;
            }

            if (Str::endsWith($contentType, '_menus')) {
                Schema::table($tableName, function (Blueprint $table) {
                    $table->uuid('update_author')->collate('utf8')->nullable()->after('author');
                });
            } else {
                Schema::table($tableName, function (Blueprint $table) {
                    $table->uuid('update_author')->collate('utf8')->nullable()->after('author');

                    $table->foreign('update_author')->references('uuid')->on('inside_content_users');
                });
            }

            DB::table($tableName)->whereNotNull('author')->update([
                'update_author' => DB::raw('`author`'),
            ]);
        }

        $sectionTypes = Inside\Content\Facades\Schema::getSectionTypes();

        foreach ($sectionTypes as $sectionType) {
            $tableName = section_type_to_table($sectionType);

            if (Schema::hasColumn($tableName, 'update_author')) {
                continue;
            }

            $sections = DB::table($tableName)->whereNotNull('author')->get();

            foreach ($sections as $section) {
                $user = Users::query()->find($section->author);

                if (! $user) {
                    DB::table($tableName)->where('uuid', $section->uuid)->update(['author' => null]);
                }
            }

            Schema::table($tableName, function (Blueprint $table) {
                $table->uuid('update_author')->collate('utf8')->nullable()->after('author');

                $table->foreign('update_author')->references('uuid')->on('inside_content_users');
            });

            DB::table($tableName)->whereNotNull('author')->update([
                'update_author' => DB::raw('`author`'),
            ]);
        }
    }
}
