<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Ramsey\Uuid\Uuid;

class WrongSectionUuidHostValueFix extends Migration
{
    public function up(): void
    {
        $sectionTypes = InsideSchema::getSectionTypes();
        foreach ($sectionTypes as $sectionType) {
            $toFix = Illuminate\Support\Facades\DB::table(section_type_to_table($sectionType))->where(
                'uuid_host',
                'like',
                '_%'
            )->get();
            foreach ($toFix as $section) {
                $uuid = (string) Uuid::uuid4();
                $buggedUuid = $section->uuid_host;
                Illuminate\Support\Facades\DB::table(section_type_to_table($sectionType))->where(
                    'uuid',
                    $section->uuid
                )->update(['uuid_host' => $uuid]);

                Illuminate\Support\Facades\DB::table('paragraphs_item')->where(
                    'uuid',
                    $buggedUuid
                )->update(['uuid' => $uuid]);
            }
        }
    }

    public function down(): void
    {
    }
}
