<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Host\Migrations\CreateContentTypes;

class CreateTextTwoColumnsSectionType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Text two columns section type');

        $this->migrateContent('text_two_columns', false, 'sections');
        $this->getConsole()->writeln('<info>Ajout du nouveau type de paragraph</info>');

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
