<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddImageLinkFieldOnImageSection extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Link field on image section');

        $this->bridge->contentTypeCreateOrUpdateField('image', 'image_link', [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'image_link',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 10,
            'title'               => [
                'fr' => 'Lien de l\'image',
                'en' => 'Image link',
            ],
            'description'         => [
                'fr' => 'Remplir si vous souhaitez ajouter un lien sur votre image',
                'en' => 'Fill in if you want to add a link on your image',
            ],
            'widget'              => [
                'type'     => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        ], 10, 'paragraph');

        $this->getConsole()->writeln('<info>Ajout du champ lien</info>');

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
