<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class AddNewFieldToEvents extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::isContentType('events')) {
            return;
        }
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'events',
            'display_hours',
            [
                'name' => 'display_hours',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'required' => false,
                'editable' => false,
                'weight' => 9,
                'title' => [
                    'fr' => 'Afficher les heures',
                    'en' => 'Display hours',
                    'es' => 'mostrar las horas',
                    'de' => 'Zeiten anzeigen',
                ],
                'description' => [
                    'fr' => '',
                    'en' => '',
                    'es' => '',
                    'de' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            9
        );
    }

    public function down(): void
    {
    }
}
