<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Section;
use Inside\Content\Models\Sections\CallToAction;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class ReworkCtaSection extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (! Schema::hasSectionType('call_to_action')) {
            return;
        }
        $this->bootUp(__FILE__, 'rework_cta_section');

        // Add a new field to save current value
        $linkFieldOptions = Schema::getFieldOptions('call_to_action', 'link');
        $this->getBridge()?->contentTypeCreateField(
            'call_to_action',
            'cta_link',
            [
                'type'                => BridgeContentType::TEXT_FIELD,
                'name'                => 'cta_link',
                'searchable'          => $linkFieldOptions['searchable'] ?? false,
                'translatable'        => $linkFieldOptions['translatable'] ?? false,
                'search_result_field' => $linkFieldOptions['search_result_field'] ?? false,
                'required'            => $linkFieldOptions['required'] ?? false,
                'weight'              => $linkFieldOptions['weight'] ?? 0,
                'title'               => $linkFieldOptions['title'] ?? ['fr' => 'Lien'],
                'description'         => $linkFieldOptions['description'] ?? ['fr' => ''],
                'widget'              => [
                    'type'     => BridgeContentType::INSIDE_LINK_WIDGET,
                    'settings' => [],
                ],
            ],
            $linkFieldOptions['weight'] ?? null,
            'paragraph'
        );

        $contentBridge = new BridgeContent();
        CallToAction::each(
            function (Section $cta) use ($contentBridge) {
                if ($cta->sectionable === null) {
                    return;
                }
                $this->getConsole()->writeln('<fg=green>Migrating <fg=cyan>['.$cta->sectionable->title.']</></>');
                $sections = $this->copySectionField($cta, 'link', 'cta_link', 'call_to_action');
                $contentBridge->contentUpdate(
                    class_to_type($cta->sectionable),
                    [
                        'uuid'    => $cta->sectionable->uuid,
                        'content' => $sections,
                    ]
                );
            }
        );
        $this->getBridge()?->contentTypeDeleteField('paragraph', 'call_to_action', 'link');
    }

    protected function copySectionField(mixed $section, string $from, string $to, string $type, bool $delete = false): array
    {
        /** @var Inside\Content\Models\Content $content */
        $content = $section->sectionable;
        $sections = [];
        foreach ($content->section_content as $section) {
            $sectionType = class_to_type($section);
            $fields = Schema::getFieldListing($sectionType);
            $data = ['bundle' => $sectionType, 'pgID' => $section->uuid];
            foreach ($fields as $fieldName) {
                $data[$fieldName] = $section->{$fieldName};
            }
            if ($sectionType == $type) {
                $data[$to] = $data[$from];
                if ($delete) {
                    unset($data[$from]);
                }
            }
            $sections[] = $data;
        }

        return $sections;
    }
}
