<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema as LaravelSchema;
use Inside\Content\Facades\Schema;

class RemoveOldModels extends Migration
{
    public function up(): void
    {
        $models = Schema::models();

        if (! $models) {
            return;
        }

        foreach ($models as $model) {
            /** @var string $table */
            $table = class_to_table($model['class']);

            if (LaravelSchema::hasTable($table)) {
                continue;
            }

            DB::table('inside_models')->where('id', $model['id'])->delete();
        }
    }

    public function down(): void
    {
    }
}
