<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Support\Str;

class GenerateAllImageStyles extends Migration
{
    use CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__, 'generate-all-image-styles');

        foreach (InsideSchema::getAllFieldsListingOfType('image') as $type => $fields) {
            if (Str::endsWith($type, '_menus')) {
                continue;
            }
            $this->getConsole()->writeln(
                'Mise-à-jour du <fg=blue>'.(InsideSchema::isSectionType($type) ? 'paragraphe' : 'contenu')
                .'</> <fg=cyan>'.$type.'</>'
            );
            foreach ($fields as $fieldName) {
                try {
                    $this->getConsole()->write('Ajout de tous les styles au champ <fg=magenta>'.$fieldName.'</>');
                    $this->getBridge()?->updateFieldOptions(
                        $type,
                        $fieldName,
                        [
                            'type'    => BridgeContentType::IMAGE_FIELD,
                            'search'  => [
                                'searchable'          => 0,
                                'global_searchable'   => 0,
                                'search_result_field' => 0,
                                'searchable_filter'   => 0,
                            ],
                            'special' => [
                                'image_styles' => [
                                    'thumbnail',
                                    'small',
                                    'medium',
                                    'big',
                                ],
                            ],
                        ]
                    );
                    $this->getConsole()->writeln(' <fg=green>✔</fg=green>');
                } catch (Throwable $e) {
                    $this->getConsole()->writeln(' <fg=red>✘</fg=red>');
                    $this->getConsole()->writeln('<fg=red;bg=white>'.$e->getMessage().'</>');
                    continue;
                }
            }
            $this->getConsole()->writeln('<fg=yellow>'.str_repeat('-', 80).'</>');
        }
        $this->getConsole()->writeln('<fg=green>Démarrage de la génération des images en tâche de fond </>');
        $this->call('inside:images:generate');
        $this->finishUp();
    }
}
