<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class ChangeBirthdayWidget extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $output = $this->getConsole();

        $fieldSettings = [
            'name'                => 'birthday',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 7,
            'title'               => [
                'es' => 'Cumpleaños',
                'de' => 'Geburtstag',
                'en' => 'Birthday',
                'fr' => 'Anniversaire',
            ],
            'description'         => [
                'es' => '',
                'de' => '',
                'en' => '',
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::INSIDE_TIMESTAMP_WIDGET,
                'settings' => [],
                'weight'   => 7,
                'group'    => 'group_advanced_options',
            ],
            'type'                => BridgeContentType::TIMESTAMP_FIELD,
            'settings'            => [],
        ];

        if (InsideSchema::hasField('users', 'birthday')) {
            $output->writeln('Champ <module>Anniverssaire</module> détecté');
            $bridge = new BridgeContentType();
            $output->write('<fg=cyan>Mise à jour du champ en cours</fg=cyan>');
            $bridge->contentTypeUpdateField('users', 'birthday', $fieldSettings);
            $output->writeln(' <fg=green>✔</fg=green>');
        }
    }

    public function down(): void
    {
    }
}
