<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;
use Inside\Content\Facades\Schema as InsideSchema;

class AddUuidHostIndex extends Migration
{
    public function up(): void
    {
        foreach (InsideSchema::getContentTypes() as $type) {
            if (Str::endsWith($type, 'menus')) {
                continue;
            }

            /** @var string $table */
            $table = type_to_table($type);
            $schemaManager = Schema::getConnection()->getDoctrineSchemaManager();
            $indexes = $schemaManager->listTableIndexes($table);

            if ($indexes && array_key_exists($table.'_uuid_host_index', $indexes)) {
                continue;
            }

            Schema::table(
                $table,
                function (Blueprint $table) {
                    $table->index('uuid_host');
                }
            );
        }
    }

    public function down(): void
    {
    }
}
