<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Models\NotificationType;

class createExportNotification extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => false,
                'event'     => null,
                'model'     => null,
                'action'    => 'export',
                'condition' => null,
                'multiple'  => true,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.content.export.title',
                    'description' => 'notifications.content.export.description',
                    'text'        => 'notifications.content.export.text',
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
