<?php

use Drupal\Core\Entity\EntityTypeInterface;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class FixDrupalMenuLinks extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        new Inside\Host\Services\DrupalService();

        if (! Schema::hasColumn('menu_link_content', 'bundle')) {
            Schema::table('menu_link_content', function (Blueprint $table) {
                $table->string('bundle', 32);
            });
        }

        $definition_update_manager = Drupal::entityDefinitionUpdateManager();

        /** @var EntityTypeInterface $entity_type */
        $entity_type = $definition_update_manager->getEntityType('menu_link_content');

        // Update the entity type definition.
        $entity_keys = $entity_type->getKeys();

        if (array_key_exists('bundle', $entity_keys)) {
            return;
        }

        $entity_keys['bundle'] = 'bundle';
        $entity_type->set('entity_keys', $entity_keys);

        $definition_update_manager->updateEntityType($entity_type);

        /** @var Drupal\menu_item_extras\Service\MenuLinkContentService $mlc_helper */
        $mlc_helper = Drupal::service('menu_item_extras.menu_link_content_helper');
        $entity_type = Drupal::entityTypeManager()->getDefinition('menu_link_content');
        Drupal::service('entity.definition_update_manager')->updateFieldableEntityType($entity_type, Drupal::service('entity_field.manager')->getFieldStorageDefinitions('menu_link_content'));
        $mlc_helper->doBundleFieldUpdate();

        $links = DB::table('menu_link_content_data')->get();

        foreach ($links as $link) {
            DB::update('update menu_link_content set bundle = "'.$link->menu_name.'" where id = ?', [$link->id]);
            DB::update('update menu_link_content_data set bundle = "'.$link->menu_name.'" where id = ?', [$link->id]);

            $menuLink = Drupal\menu_link_content\Entity\MenuLinkContent::load($link->id);
            $menuLink->save();
        }
    }
}
