<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class AddFieldNameToPivotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        if (! Schema::hasColumn('inside_pivots', 'related_field')) {
            Schema::table('inside_pivots', function (Blueprint $table) {
                $table->string('related_field', 255)->default('');
            });

            $pivots = DB::select('select * from inside_pivots');

            foreach ($pivots as $pivot) {
                $related = $pivot->related_type;
                $related = str_replace('Inside\Content\Models\Contents\\', '', $related);
                DB::update('update inside_pivots set related_field = "'.Str::snake($related).'" where id = ?', [$pivot->id]);
            }
        }
    }
}
