<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Helpers\SchemaHelper;

class AddNullableToAuthorColumns extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $tables = SchemaHelper::listContentTables();

        foreach ($tables as $table) {
            if (Schema::hasColumn($table, 'author') && strpos($table, '_menus') === false && strpos($table, '_users') === false) {
                Schema::table($table, function (Blueprint $table) {
                    //   $table->dropForeign($table->getTable() . '_author_foreign');
                });
                Schema::table($table, function (Blueprint $table) {
                    $table->string('author')->nullable()->default(null)->change();
                    $table->foreign('author')->references('uuid')->on('inside_content_users');
                });
            }
        }
    }
}
