<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Helpers\SchemaHelper;

class AddStatusToContentTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $tables = SchemaHelper::listContentTables();

        foreach ($tables as $table) {
            if (! Schema::hasColumn($table, 'status')) {
                Schema::table($table, function (Blueprint $table) {
                    $table->tinyInteger('status')->default(0)->after('uuid_host');
                    $table->index('status');
                });
            }
        }
    }
}
