<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Helpers\SchemaHelper;

class CreateMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_content_main_menu_links', function (Blueprint $table) {
            $table->uuid('uuid')->collate('utf8');
            $table->uuid('uuid_host')->collate('utf8');
            $table->uuid('author')->collate('utf8')->nullable();
            $table->string('title', 255)->nullable();
            $table->string('link', 255);
            $table->integer('weight')->default(0);
            $table->uuid('pid')->collate('utf8')->nullable();
            $table->char('langcode', 2)->nullable();
            $table->timestamps();
            $table->primary('uuid');
            $table->index('uuid');
            $table->index('pid');
            $table->index(['uuid', 'langcode']);
        });

        Schema::create('inside_content_footer_menu_links', function (Blueprint $table) {
            $table->uuid('uuid')->collate('utf8');
            $table->uuid('uuid_host')->collate('utf8');
            $table->uuid('author')->collate('utf8')->nullable();
            $table->string('title', 255)->nullable();
            $table->string('link', 255);
            $table->integer('weight')->default(0);
            $table->uuid('pid')->collate('utf8')->nullable();
            $table->char('langcode', 2)->nullable();
            $table->timestamps();
            $table->primary('uuid');
            $table->index('uuid');
            $table->index('pid');
            $table->index(['uuid', 'langcode']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_content_main_menu_links');
        Schema::dropIfExists('inside_content_footer_menu_links');
    }
}
