<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RefactorInsideFieldsTable extends Migration
{
    public function up(): void
    {
        $needToMigrate = false;
        Schema::table(
            'inside_fields',
            function (Blueprint $table) use (&$needToMigrate) {
                if (! Schema::hasColumn('inside_fields', 'model_id')) {
                    $table->unsignedInteger('model_id')->after('model');
                    $needToMigrate = true;
                }
            }
        );

        if ($needToMigrate) {
            $models = collect();

            // Migrate
            foreach (Inside\Content\Models\Field::all() as $field) {
                $model = $field->getOriginal('model');
                if (! $models->has($model)) {
                    try {
                        $models[$model] = Inside\Content\Models\Model::where('model', $model)->firstOrFail();
                    } catch (Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                        $field->delete();
                        continue;
                    }
                }
                $field->model_id = $models[$model]->id;
                $field->save();
            }

            Schema::table(
                'inside_fields',
                function (Blueprint $table) {
                    $table->foreign('model_id')->references('id')->on('inside_models')->onDelete('cascade');
                }
            );
        }

        Schema::table(
            'inside_fields',
            function (Blueprint $table) {
                $sm = Schema::getConnection()->getDoctrineSchemaManager();
                $doctrineTable = $sm->listTableDetails('inside_fields');

                if ($doctrineTable->hasIndex('inside_fields_model_index')) {
                    $table->dropIndex('inside_fields_model_index');
                }
                if ($doctrineTable->hasIndex('inside_fields_model_name_unique')) {
                    $table->dropUnique('inside_fields_model_name_unique');
                }
                if (Schema::hasColumn('inside_fields', 'model')) {
                    $table->dropColumn('model');
                }
                if (! $doctrineTable->hasIndex('model_id_name')) {
                    $table->unique(['model_id', 'name'], 'model_id_name');
                }
            }
        );

        Schema::table(
            'inside_models',
            function (Blueprint $table) {
                $sm = Schema::getConnection()->getDoctrineSchemaManager();
                $doctrineTable = $sm->listTableDetails('inside_models');
                if ($doctrineTable->hasIndex('inside_models_model_index')) {
                    $table->dropIndex('inside_models_model_index');
                }
                if ($doctrineTable->hasIndex('inside_models_model_unique')) {
                    $table->dropUnique('inside_models_model_unique');
                }
                if (Schema::hasColumn('inside_models', 'model')) {
                    $table->renameColumn('model', 'class');
                }
                if (! $doctrineTable->hasIndex('inside_models_class_unique')) {
                    $table->unique('class');
                }
            }
        );
    }

    public function down(): void
    {
    }
}
