<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Migrations\CreateContentTypes;

class FixSectionAuthors extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $subSections = [];

        foreach (InsideSchema::getSectionTypes() as $type) {
            $table = section_type_to_table($type);

            $sections = DB::table($table)->whereNull('author')->get();

            foreach ($sections as $section) {
                if (strstr($section->sectionable_type, '\Sections\\')) {
                    $subSections[] = $type;
                    continue;
                }

                $parent = DB::table(class_to_table($section->sectionable_type))->where('uuid', $section->sectionable_uuid)->first();

                if (! $parent) {
                    continue;
                }

                DB::table($table)->where('uuid', $section->uuid)->update([
                    'author' => $parent->author,
                    'author_id' => $parent->author,
                ]);
            }
        }

        foreach ($subSections as $subSection) {
            $parent = DB::table(class_to_table($section->sectionable_type))->where('uuid', $section->sectionable_uuid)->first();

            if (! $parent) {
                continue;
            }

            DB::table($table)->where('uuid', $section->uuid)->update([
                'author' => $parent->author,
                'author_id' => $parent->author,
            ]);
        }
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
