<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;
use Inside\Content\Exceptions\FieldSchemaNotFoundException;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Content;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Symfony\Component\Console\Helper\ProgressBar;

class AddAuthorIdColumnOnSections extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $console = $this->getConsole();

        foreach (InsideSchema::getSectionTypes() as $type) {
            $table = section_type_to_table($type);
            if (Schema::hasColumn($table, 'author_id')) {
                $console->writeln('<note>Section <fg=cyan>'.$type.
                    '</> already has a <fg=magenta>author_id</> field!!!</>');
                continue;
            }
            $console->writeln('<info>Adding author_id column to section <fg=cyan>'.$type.'</></info>');

            // Add column
            Schema::table(
                $table,
                function (Blueprint $table) {
                    $table->uuid('author_id')->nullable()->after('author');
                }
            );

            // Copy author to author_id
            DB::table($table)->update(['author_id' => DB::raw('author')]);
            Schema::table(
                $table,
                function (Blueprint $table) {
                    $table->uuid('author_id')->nullable(false)->change();
                }
            );
        }
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
