<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'top_footer',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Sur footer',
            'en' => 'Top footer',
            'es' => 'Pie superior',
            'pt' => 'Rodapé superior',
            'de' => 'Oberer Footer',
            'nl' => 'Bovenste Footer',
        ],
    ],
    'fields' => [
        [
            'name' => 'banner',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'es' => 'Pancarta',
                'pt' => 'Faixa',
                'de' => 'Banner',
                'nl' => 'Spandoek',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'banner_top_footer_home',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
