<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => false,
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => false,
        'permissible'       => false,
        'categorizable'     => false,
        'name'              => 'image_styles',
        'title'             => [
            'fr' => 'Styles d\'images',
            'en' => 'Images styles',
        ],
    ],
    'fields'  => [
        // width
        [
            'type'                => BridgeContentType::INTEGER_FIELD,
            'name'                => 'width',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => $weight++,
            'default'             => '80',
            'title'               => [
                'fr' => 'Largeur',
                'en' => 'Width',
            ],
            'description'         => [
                'fr' => 'La largeur de l\'image',
                'en' => 'Image width',
            ],
            'settings'            => [
                'cardinality' => 1,
                'min' => '0',
            ],
            'widget'              => [
                'type'     => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
            ],
        ],

        // height
        [
            'type'                => BridgeContentType::INTEGER_FIELD,
            'name'                => 'height',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => $weight++,
            'default'             => '60',
            'title'               => [
                'fr' => 'Hauteur',
                'en' => 'Height',
            ],
            'description'         => [
                'fr' => 'La hauteur de l\'image',
                'en' => 'Image height',
            ],
            'settings'            => [
                'cardinality' => 1,
                'min' => '0',
            ],
            'widget'              => [
                'type'     => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
            ],
        ],

        // optimisation
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'optimisation',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => $weight++,
            'default' => true,
            'title'               => [
                'fr' => 'Optimisation',
                'en' => 'Optimization',
            ],
            'description'         => [
                'fr' => 'Faut il optimiser l\'image ?',
                'en' => 'Image optimization ?',
            ],
            'settings'            => [
                'cardinality' => 1,
            ],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // optimisation_ratio
        [
            'type'                => BridgeContentType::INTEGER_FIELD,
            'name'                => 'optimisation_ratio',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => $weight++,
            'default'             => '80',
            'title'               => [
                'fr' => 'Taux d\'optimisation',
                'en'  => 'Image optimization rate',
            ],
            'description'         => [
                'fr' => '( en pourcentage ) De 0 à 100',
                'en' => '( in percent ) From 0 to 100',
            ],
            'settings'            => [
                'cardinality' => 1,
                'min' => '0',
                'max' => '100',
            ],
            'widget'              => [
                'type'     => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
            ],
        ],
        [
            'name' => 'resizable',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => $weight++,
            'title' => [
                'fr' => 'Redimensionner l\'image',
                'en' => 'Resize image',
            ],
            'description' => [
                'fr' => 'Avec cette option, l\'image générée gardera son ratio et aura des bandes blanches sur les côtés',
                'en' => 'With this option, the generated image will keep its ratio and will have blank borders',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
