<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'media_viewer',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Carrousel',
            'en' => 'Carousel',
            'es' => 'Carrusel',
            'pt' => 'Carrossel',
            'de' => 'Karussell',
            'nl' => 'Carrousel',
        ],
    ],
    'fields' => [
        [
            'name' => 'chapo',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'es' => 'Introducción',
                'nl' => 'Inleiding',
                'de' => 'Einführung',
                'pt' => 'Introdução',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'es' => 'Contenido',
                'pt' => 'Conteúdo',
                'de' => 'Inhalt',
                'nl' => 'Inhoud',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'slide_image',
                    'slide_video',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
