<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'connexion_popups',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Popin de connexion',
            'en' => 'Connexion pop-up',
            'es' => 'Ventana emergente de conexión',
            'de' => 'Anmelde-Pop-up',
            'pt' => 'Janela pop-up de conexão',
            'nl' => 'Inlog-pop-up',
        ],
    ],
    'fields' => [
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'es' => 'Contenido',
                'pt' => 'Conteúdo',
                'de' => 'Inhalt',
                'nl' => 'Inhoud',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'end_date',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Date de fin',
                'en' => 'End date',
                'es' => 'Fecha de finalización',
                'pt' => 'Data de término',
                'de' => 'Enddatum',
                'nl' => 'Einddatum',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
