<?php

declare(strict_types=1);

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'forms',
    ],
    'fields' => [
        [
            'name' => 'job_offers_form_template',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => "Template formulaire d'offres d'emploi",
                'en' => 'Job offers template form',
                'es' => 'Plantilla de formulario de publicación de trabajo',
                'de' => 'Vorlage für ein Stellenausschreibungsformular',
                'pt' => 'Modelo de formulário de anúncio de emprego',
            ],
            'description' => [
                'fr' => "Utilise ce formulaire comme modèle aux formulaires d'application aux offres d'emploi générés automatiquement",
                'en' => 'Use this form as a template for automatically generated job application forms',
                'es' => 'Utilice este formulario como plantilla para formularios de solicitud de empleo generados automáticamente',
                'de' => 'Verwenden Sie dieses Formular als Vorlage für automatisch generierte Bewerbungsformulare',
                'pt' => 'Use este formulário como um modelo para formulários de candidatura a emprego gerados automaticamente',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 1,
                'hidden' => true,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'job_offers_form',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => "Formulaire d'offres d'emploi",
                'en' => 'Job application form',
                'es' => 'Formulario de ofertas de trabajo',
                'de' => 'Formular für Stellenangebote',
                'pt' => 'formulário de ofertas de emprego',
            ],
            'description' => [
                'fr' => 'This form is linked to a job offer',
                'en' => "Ce formulaire est lié à une offre d'emploi",
                'es' => 'Este formulario está vinculado a una oferta de trabajo',
                'de' => 'Dieses Formular ist mit einem Stellenangebot verknüpft',
                'pt' => 'Este formulário está vinculado a uma oferta de emprego',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 1,
                'hidden' => true,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
