#!/bin/sh

ARTISAN_CLI=artisan
ARTISAN_ARG="queue:work --daemon"
ARTISAN_QUEUE_PID=`ps aux | grep "${ARTISAN_CLI} ${ARTISAN_ARG}" | grep "php" | awk 'END {print $2}'`
SCRIPT_PATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
ARTISAN_PATH=${SCRIPT_PATH}/../

while [ ! -z $ARTISAN_QUEUE_PID ]
do
    printf "Stopping Artisan Queue (pid:${ARTISAN_QUEUE_PID})...\n"
    kill -TERM ${ARTISAN_QUEUE_PID} 2>/dev/null
    ARTISAN_QUEUE_PID=`ps aux | grep "${ARTISAN_CLI} ${ARTISAN_ARG}" | grep "php" | awk 'END {print $2}'`
done

printf "Launching Artisan Queue...\n"
nohup php ${ARTISAN_PATH}${ARTISAN_CLI} ${ARTISAN_ARG} &
ARTISAN_QUEUE_PID=`ps aux | grep "${ARTISAN_CLI} ${ARTISAN_ARG}" | grep "php" | awk 'END {print $2}'`

if [ ! -z "$ARTISAN_QUEUE_PID" ]; then
    printf "Artisan Queue started (pid:$ARTISAN_QUEUE_PID).\n"
else
    printf "Artisan Queue cannot daemonize.\n"
fi
