<?php

namespace Inside\Authentication\Validators;

use Illuminate\Contracts\Validation\Validator as ValidatorContract;
use Illuminate\Support\Facades\Validator as ValidatorFacade;
use Inside\Authentication\Exceptions\CredentialsValidatorException;

class AuthenticationValidator
{
    protected array $rules = [
        'name'     => 'required_without:email|string',
        'email'    => 'email|required_without:name|string',
        'password' => 'required|string',
    ];

    /**
     * Validate data with given rules
     *
     * @throws CredentialsValidatorException
     */
    public function validate(mixed $data): void
    {
        $validator = ValidatorFacade::make($data, $this->rules);

        if ($validator->fails()) {
            $errors = $this->formatErrors($validator);
            throw new CredentialsValidatorException(implode(' ', $errors));
        }
    }

    protected function formatErrors(ValidatorContract $validator): array
    {
        $errors = [];
        $messages = $validator->getMessageBag();

        foreach ($messages->keys() as $key) {
            $errors[$key] = implode('\\n', $messages->get($key));
        }

        return $errors;
    }
}
