<?php

namespace Inside\Authentication\Services;

class SfrSmsSenderService
{
    /**
     * @var string
     */
    private $serviceId;

    /**
     * @var string
     */
    private $servicePass;

    /**
     * @var string
     */
    private $spaceId;

    public function __construct()
    {
        $this->serviceId = env('SFR_SERVICE_ID');
        $this->servicePass = env('SFR_SERVICE_PASS');
        $this->spaceId = env('SFR_SPACE_ID');

        if (! $this->serviceId || ! $this->servicePass || ! $this->spaceId) {
            throw new \Exception('Check the config parameters of SFR API !');
        }
    }

    /**
     * @param string $phoneNumber
     * @param string $text
     * @return mixed
     */
    public function sendSms(string $phoneNumber, string $text)
    {
        $auth = [
            'serviceId' => $this->serviceId,
            'servicePassword' => $this->servicePass,
            'spaceId' => $this->spaceId,
        ];

        $message = [
            'to' => $phoneNumber,
            'textMsg' => $text,
            'media' => 'SMS',
        ];

        /* Convert into JSON format */
        $auth_json = urlencode(json_encode($auth));
        $msg_json = urlencode(json_encode($message));

        /* Request Arguments */
        $query_data = 'authenticate='.$auth_json.'&messageUnitaire='.$msg_json;

        /* Build the URL Of the Service */
        $send_query = 'https://www.dmc.sfr-sh.fr/DmcWS/1.5/JsonService/MessagesUnitairesWS/addSingleCall?'.$query_data;

        /* Getting the result */
        return json_decode(file_get_contents($send_query));
    }
}
