<?php

declare(strict_types=1);

namespace Inside\Authentication\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Contracts\Authentication as AuthenticationContract;
use Inside\Authentication\Models\User;

final class KeepCookieAliveIfNeeded
{
    public function __construct(
        protected AuthenticationContract $service
    ) {
    }

    public function handle(Request $request, Closure $next): mixed
    {
        if (Auth::check() && Auth::user() instanceof User) {
            $this->service->updateMagieCookieLifetime($request);
        }

        return $next($request);
    }
}
