<?php

namespace Inside\Authentication\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Inside\Authentication\Facades\Authentication;
use Symfony\Component\HttpKernel\Exception\UnauthorizedHttpException;

class ExternalJwtClientAuthenticate
{
    public function handle(Request $request, Closure $next, mixed ...$applications): mixed
    {
        foreach ($applications as $application) {
            if (Authentication::checkExternalJWTToken($application)) {
                return $next($request);
            }
        }

        throw new UnauthorizedHttpException('external-auth', 'This action is unauthorized.');
    }
}
