<?php

namespace Inside\Authentication\Facades;

use Illuminate\Support\Facades\Facade;
use Inside\Authentication\Contracts\InsideSessionLifetime as InsideSessionLifetimeContract;

/**
 * @method static int|null getAuthenticatorLifetime(string $authenticator, bool $longer)
 * @method static int getSessionLifetime()
 * @method static int getSessionLongerLifetime()
 * @method static int getSessionSSOLifetime()
 */
class InsideSessionLifetime extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return InsideSessionLifetimeContract::class;
    }
}
